<?php
/**
 * @package    Hotspots
 * @author     DanielDimitrov <daniel@compojoom.com>
 * @date       18.09.14
 *
 * @copyright  Copyright (C) 2008 - 2013 compojoom.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

/**
 * This script is based on the Installer Plugins from AkeebaBackup.com by
 * Nicholas K. Dionysopoulos. Check out AkeebaBackup.com for more great extensions.
 */

defined('_JEXEC') or die('Restricted access');

/**
 * Handle commercial extension update authorization
 *
 * @package     Joomla.Plugin
 * @subpackage  Installer.Admintools
 * @since       2.5
 */
class PlgInstallerHotspots extends JPlugin
{
	/**
	 * @var    String  your extension identifier, to retrieve its params
	 * @since  2.5
	 */
	private $extension = 'com_hotspots';

	/**
	 * Handle adding credentials to package download request.
	 *
	 * The onInstallerBeforePackageDownload() event is available since Joomla! 2.5.19 and 3.2.3. It's required
	 * for updating extensions on Joomla! 2.5.19 and all later versions in the 2.5.x range, since these Joomla!
	 * versions don't have the extra_query column of #__update_sites.
	 *
	 * We don't install this plugin on Joomla 3.x.x, because we only need this plugin on these Joomla! versions
	 * when someone enters his download ID without visiting the Control Panel of the component afterwards.
	 * Normally the Control Panel should always be visited after editing the component configuration. There could
	 * be an exception when the user e.g. edits the Download ID, then edits the configuration of another
	 * component and visits the Joomla! updater. Or e.g. when a user directly visits the Joomla! updater
	 * after saving the Download ID. This is just a small chance, these users should just be asked to visit the
	 * component's Control Panel if they're having this issue.
	 *
	 * This event is NOT available for:
	 *
	 * - Joomla! 2.5.0 - 2.5.18		Updating these versions via the Joomla! extensions updater is not supported,
	 * 								because these versions neither have the onInstallerBeforePackageDownload() event nor
	 * 								the extra_query column of #__update_sites.
	 * - Joomla! 3.0.0 - 3.2.2	 	For these Joomla! versions we need to add the download ID to the extra_query column
	 * 								via the Control Panel of our component, because this event is unavailable.
	 *
	 * @param   string  &$url      url from which package is going to be downloaded
	 * @param   array   &$headers  headers to be sent along the download request (key => value format)
	 *
	 * @return  boolean true if credentials have been added to request or not our business, false otherwise (credentials not set by user)
	 *
	 * @since   2.5
	 */
	public function onInstallerBeforePackageDownload(&$url, &$headers)
	{
		$uri = JUri::getInstance($url);
		$host = $uri->getHost();

		/**
		 * I don't care about download URLs not coming from our site
		 * Note: as the Download ID is common for all extensions, this plugin will be triggered for all
		 * extensions with a download URL on our site
		 */
		if (!in_array($host, array('https://compojoom.com', 'compojoom.com')))
		{
			return true;
		}

		// Get the download ID
		JLoader::import('joomla.application.component.helper');
		$component = JComponentHelper::getComponent($this->extension);

		$dlid = $component->params->get('downloadid', '');

		// If the download ID is invalid, return without any further action
		if (!preg_match('/^([0-9]{1,}:)?[0-9a-f]{32}$/i', $dlid))
		{
			return true;
		}

		// Append the Download ID to the download URL
		if (!empty($dlid))
		{
			$uri->setVar('dlid', $dlid);
			$url = $uri->toString();
		}

		return true;
	}
}
