<?php
/**
 * @package    Com_Hotspots
 * @author     DanielDimitrov <daniel@compojoom.com>
 * @date       02.02.15
 *
 * @copyright  Copyright (C) 2008 - 2013 compojoom.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.view');

/**
 * The view class for raw requests
 *
 * Class HotspotsViewHotspot
 *
 * @package  Hotspots
 * @since    3.4
 */
class HotspotsViewHotspot extends HotspotsView
{
	/**
	 * The display funciton
	 *
	 * @param   null $tpl  - the template
	 *
	 * @return mixed|void
	 */
	public function display($tpl = null)
	{
		$model = $this->getModel();
		$this->profile = '';
		$this->hotspot = HotspotsHelperUtils::prepareHotspot($model->getHotspot());

		// Load profiles
		if ($this->hotspot->created_by && HotspotsHelperSettings::get('profile_link', ''))
		{
			$profileSystem = CompojoomProfiles::getInstance(HotspotsHelperSettings::get('profile_link', ''));

			$this->profile = $profileSystem->getLink($this->hotspot->created_by);
		}

		$this->settings = $this->prepareSettings();

		$this->setLayout('single');
		parent::display('raw');
	}

	/**
	 * Sets some settings so that they can be easily accessed
	 *
	 * @return JObject
	 */
	private function prepareSettings()
	{
		$settings = new JObject;
		$properties = array(
			'show_address' => HotspotsHelperSettings::get('show_address', 1),
			'show_country' => HotspotsHelperSettings::get('show_address_country', 0),
			'show_author' => HotspotsHelperSettings::get('show_author', 1),
			'show_date' => HotspotsHelperSettings::get('show_date', 1),
			'show_detailpage' => HotspotsHelperSettings::get('hotspot_detailpage', 1)
		);

		$settings->setProperties($properties);

		return $settings;
	}
}
