(function(sceditor){"use strict";var escapeEntities=sceditor.escapeEntities;var escapeUriScheme=sceditor.escapeUriScheme;var dom=sceditor.dom;var utils=sceditor.utils;var css=dom.css;var attr=dom.attr;var is=dom.is;var extend=utils.extend;var each=utils.each;var IE_VER=sceditor.ie;var IE_BR_FIX=IE_VER&&IE_VER<11;var EMOTICON_DATA_ATTR="data-sceditor-emoticon";var getEditorCommand=sceditor.command.get;var QuoteType={always:1,never:2,auto:3};var defaultCommandsOverrides={bold:{txtExec:["[b]","[/b]"]},italic:{txtExec:["[i]","[/i]"]},underline:{txtExec:["[u]","[/u]"]},strike:{txtExec:["[s]","[/s]"]},subscript:{txtExec:["[sub]","[/sub]"]},superscript:{txtExec:["[sup]","[/sup]"]},left:{txtExec:["[left]","[/left]"]},center:{txtExec:["[center]","[/center]"]},right:{txtExec:["[right]","[/right]"]},justify:{txtExec:["[justify]","[/justify]"]},font:{txtExec:function(caller){var editor=this;getEditorCommand("font")._dropDown(editor,caller,function(fontName){editor.insertText("[font="+fontName+"]","[/font]")})}},size:{txtExec:function(caller){var editor=this;getEditorCommand("size")._dropDown(editor,caller,function(fontSize){editor.insertText("[size="+fontSize+"]","[/size]")})}},color:{txtExec:function(caller){var editor=this;getEditorCommand("color")._dropDown(editor,caller,function(color){editor.insertText("[color="+color+"]","[/color]")})}},bulletlist:{txtExec:function(caller,selected){var content="";each(selected.split(/\r?\n/),function(){content+=(content?"\n":"")+"[li]"+this+"[/li]"});this.insertText("[ul]\n"+content+"\n[/ul]")}},orderedlist:{txtExec:function(caller,selected){var content="";each(selected.split(/\r?\n/),function(){content+=(content?"\n":"")+"[li]"+this+"[/li]"});this.insertText("[ol]\n"+content+"\n[/ol]")}},table:{txtExec:["[table][tr][td]","[/td][/tr][/table]"]},horizontalrule:{txtExec:["[hr]"]},code:{txtExec:["[code]","[/code]"]},image:{txtExec:function(caller,selected){var editor=this;getEditorCommand("image")._dropDown(editor,caller,selected,function(url,width,height){var attrs="";if(width){attrs+=" width="+width}if(height){attrs+=" height="+height}editor.insertText("[img"+attrs+"]"+url+"[/img]")})}},email:{txtExec:function(caller,selected){var editor=this;getEditorCommand("email")._dropDown(editor,caller,function(url,text){editor.insertText("[email="+url+"]"+(text||selected||url)+"[/email]")})}},link:{txtExec:function(caller,selected){var editor=this;getEditorCommand("link")._dropDown(editor,caller,function(url,text){editor.insertText("[url="+url+"]"+(text||selected||url)+"[/url]")})}},quote:{txtExec:["[quote]","[/quote]"]},youtube:{txtExec:function(caller){var editor=this;getEditorCommand("youtube")._dropDown(editor,caller,function(id){editor.insertText("[youtube]"+id+"[/youtube]")})}},rtl:{txtExec:["[rtl]","[/rtl]"]},ltr:{txtExec:["[ltr]","[/ltr]"]}};var bbcodeHandlers={b:{tags:{b:null,strong:null},styles:{"font-weight":["bold","bolder","401","700","800","900"]},format:"[b]{0}[/b]",html:"<strong>{0}</strong>"},i:{tags:{i:null,em:null},styles:{"font-style":["italic","oblique"]},format:"[i]{0}[/i]",html:"<em>{0}</em>"},u:{tags:{u:null},styles:{"text-decoration":["underline"]},format:"[u]{0}[/u]",html:"<u>{0}</u>"},s:{tags:{s:null,strike:null},styles:{"text-decoration":["line-through"]},format:"[s]{0}[/s]",html:"<s>{0}</s>"},sub:{tags:{sub:null},format:"[sub]{0}[/sub]",html:"<sub>{0}</sub>"},sup:{tags:{sup:null},format:"[sup]{0}[/sup]",html:"<sup>{0}</sup>"},font:{tags:{font:{face:null}},styles:{"font-family":null},quoteType:QuoteType.never,format:function(element,content){var font;if(!is(element,"font")||!(font=attr(element,"face"))){font=css(element,"font-family")}return"[font="+_stripQuotes(font)+"]"+content+"[/font]"},html:'<font face="{defaultattr}">{0}</font>'},size:{tags:{font:{size:null}},styles:{"font-size":null},format:function(element,content){var fontSize=attr(element,"size"),size=2;if(!fontSize){fontSize=css(element,"fontSize")}if(fontSize.indexOf("px")>-1){fontSize=fontSize.replace("px","")-0;if(fontSize<12){size=1}if(fontSize>15){size=3}if(fontSize>17){size=4}if(fontSize>23){size=5}if(fontSize>31){size=6}if(fontSize>47){size=7}}else{size=fontSize}return"[size="+size+"]"+content+"[/size]"},html:'<font size="{defaultattr}">{!0}</font>'},color:{tags:{font:{color:null}},styles:{color:null},quoteType:QuoteType.never,format:function(elm,content){var color;if(!is(elm,"font")||!(color=attr(elm,"color"))){color=elm.style.color||css(elm,"color")}return"[color="+_normaliseColour(color)+"]"+content+"[/color]"},html:function(token,attrs,content){return'<font color="'+escapeEntities(_normaliseColour(attrs.defaultattr),true)+'">'+content+"</font>"}},ul:{tags:{ul:null},breakStart:true,isInline:false,skipLastLineBreak:true,format:"[ul]{0}[/ul]",html:"<ul>{0}</ul>"},list:{breakStart:true,isInline:false,skipLastLineBreak:true,html:"<ul>{0}</ul>"},ol:{tags:{ol:null},breakStart:true,isInline:false,skipLastLineBreak:true,format:"[ol]{0}[/ol]",html:"<ol>{0}</ol>"},li:{tags:{li:null},isInline:false,closedBy:["/ul","/ol","/list","*","li"],format:"[li]{0}[/li]",html:"<li>{0}</li>"},"*":{isInline:false,closedBy:["/ul","/ol","/list","*","li"],html:"<li>{0}</li>"},table:{tags:{table:null},isInline:false,isHtmlInline:true,skipLastLineBreak:true,format:"[table]{0}[/table]",html:"<table>{0}</table>"},tr:{tags:{tr:null},isInline:false,skipLastLineBreak:true,format:"[tr]{0}[/tr]",html:"<tr>{0}</tr>"},th:{tags:{th:null},allowsEmpty:true,isInline:false,format:"[th]{0}[/th]",html:"<th>{0}</th>"},td:{tags:{td:null},allowsEmpty:true,isInline:false,format:"[td]{0}[/td]",html:"<td>{0}</td>"},emoticon:{allowsEmpty:true,tags:{img:{src:null,"data-sceditor-emoticon":null}},format:function(element,content){return attr(element,EMOTICON_DATA_ATTR)+content},html:"{0}"},hr:{tags:{hr:null},allowsEmpty:true,isSelfClosing:true,isInline:false,format:"[hr]{0}",html:"<hr />"},img:{allowsEmpty:true,tags:{img:{src:null}},allowedChildren:["#"],quoteType:QuoteType.never,format:function(element,content){var width,height,attribs="",style=function(name){return element.style?element.style[name]:null};if(attr(element,EMOTICON_DATA_ATTR)){return content}width=attr(element,"width")||style("width");height=attr(element,"height")||style("height");if(element.complete&&(width||height)||width&&height){attribs="="+dom.width(element)+"x"+dom.height(element)}return"[img"+attribs+"]"+attr(element,"src")+"[/img]"},html:function(token,attrs,content){var undef,width,height,match,attribs="";width=attrs.width;height=attrs.height;if(attrs.defaultattr){match=attrs.defaultattr.split(/x/i);width=match[0];height=match.length===2?match[1]:match[0]}if(width!==undef){attribs+=' width="'+escapeEntities(width,true)+'"'}if(height!==undef){attribs+=' height="'+escapeEntities(height,true)+'"'}return"<img"+attribs+' src="'+escapeUriScheme(content)+'" />'}},url:{allowsEmpty:true,tags:{a:{href:null}},quoteType:QuoteType.never,format:function(element,content){var url=attr(element,"href");if(url.substr(0,7)==="mailto:"){return'[email="'+url.substr(7)+'"]'+content+"[/email]"}return"[url="+url+"]"+content+"[/url]"},html:function(token,attrs,content){attrs.defaultattr=escapeEntities(attrs.defaultattr,true)||content;return'<a href="'+escapeUriScheme(attrs.defaultattr)+'">'+content+"</a>"}},email:{quoteType:QuoteType.never,html:function(token,attrs,content){return'<a href="mailto:'+(escapeEntities(attrs.defaultattr,true)||content)+'">'+content+"</a>"}},quote:{tags:{blockquote:null},isInline:false,quoteType:QuoteType.never,format:function(element,content){var authorAttr="data-author";var author="";var cite;var children=element.children;for(var i=0;!cite&&i<children.length;i++){if(is(children[i],"cite")){cite=children[i]}}if(cite||attr(element,authorAttr)){author=cite&&cite.textContent||attr(element,authorAttr);attr(element,authorAttr,author);if(cite){element.removeChild(cite)}content=this.elementToBbcode(element);author="="+author.replace(/(^\s+|\s+$)/g,"");if(cite){element.insertBefore(cite,element.firstChild)}}return"[quote"+author+"]"+content+"[/quote]"},html:function(token,attrs,content){if(attrs.defaultattr){content="<cite>"+escapeEntities(attrs.defaultattr)+"</cite>"+content}return"<blockquote>"+content+"</blockquote>"}},code:{tags:{code:null},isInline:false,allowedChildren:["#","#newline"],format:"[code]{0}[/code]",html:"<code>{0}</code>"},left:{styles:{"text-align":["left","-webkit-left","-moz-left","-khtml-left"]},isInline:false,format:"[left]{0}[/left]",html:'<div align="left">{0}</div>'},center:{styles:{"text-align":["center","-webkit-center","-moz-center","-khtml-center"]},isInline:false,format:"[center]{0}[/center]",html:'<div align="center">{0}</div>'},right:{styles:{"text-align":["right","-webkit-right","-moz-right","-khtml-right"]},isInline:false,format:"[right]{0}[/right]",html:'<div align="right">{0}</div>'},justify:{styles:{"text-align":["justify","-webkit-justify","-moz-justify","-khtml-justify"]},isInline:false,format:"[justify]{0}[/justify]",html:'<div align="justify">{0}</div>'},youtube:{allowsEmpty:true,tags:{iframe:{"data-youtube-id":null}},format:function(element,content){element=attr(element,"data-youtube-id");return element?"[youtube]"+element+"[/youtube]":content},html:'<iframe width="560" height="315" frameborder="0" '+'src="https://www.youtube.com/embed/{0}?wmode=opaque" '+'data-youtube-id="{0}" allowfullscreen></iframe>'},rtl:{styles:{direction:["rtl"]},isInline:false,format:"[rtl]{0}[/rtl]",html:'<div style="direction: rtl">{0}</div>'},ltr:{styles:{direction:["ltr"]},isInline:false,format:"[ltr]{0}[/ltr]",html:'<div style="direction: ltr">{0}</div>'},ignore:{}};function formatBBCodeString(str,obj){return str.replace(/\{([^}]+)\}/g,function(match,group){var undef,escape=true;if(group.charAt(0)==="!"){escape=false;group=group.substring(1)}if(group==="0"){escape=false}if(obj[group]===undef){return match}return escape?escapeEntities(obj[group],true):obj[group]})}function removeFirstLastDiv(html){var node,next,removeDiv,output=document.createElement("div");removeDiv=function(node,isFirst){if(dom.hasStyling(node)){return}if(IE_BR_FIX||(node.childNodes.length!==1||!is(node.firstChild,"br"))){while(next=node.firstChild){output.insertBefore(next,node)}}if(isFirst){var lastChild=output.lastChild;if(node!==lastChild&&is(lastChild,"div")&&node.nextSibling===lastChild){output.insertBefore(document.createElement("br"),node)}}output.removeChild(node)};css(output,"display","none");output.innerHTML=html.replace(/<\/div>\n/g,"</div>");if((node=output.firstChild)&&is(node,"div")){removeDiv(node,true)}if((node=output.lastChild)&&is(node,"div")){removeDiv(node)}return output.innerHTML}function isFunction(fn){return typeof fn==="function"}function _stripQuotes(str){return str?str.replace(/\\(.)/g,"$1").replace(/^(["'])(.*?)\1$/,"$2"):str}function _formatString(str){var undef;var args=arguments;return str.replace(/\{(\d+)\}/g,function(_,matchNum){return args[matchNum-0+1]!==undef?args[matchNum-0+1]:"{"+matchNum+"}"})}var TOKEN_OPEN="open";var TOKEN_CONTENT="content";var TOKEN_NEWLINE="newline";var TOKEN_CLOSE="close";function TokenizeToken(type,name,val,attrs,children,closing){var base=this;base.type=type;base.name=name;base.val=val;base.attrs=attrs||{};base.children=children||[];base.closing=closing||null}TokenizeToken.prototype={clone:function(){var base=this;return new TokenizeToken(base.type,base.name,base.val,extend({},base.attrs),[],base.closing?base.closing.clone():null)},splitAt:function(splitAt){var offsetLength;var base=this;var clone=base.clone();var offset=base.children.indexOf(splitAt);if(offset>-1){offsetLength=base.children.length-offset;clone.children=base.children.splice(offset,offsetLength)}return clone}};function BBCodeParser(options){var base=this;base.opts=extend({},BBCodeParser.defaults,options);base.tokenize=function(str){var matches,type,i;var tokens=[];var tokenTypes=[{type:TOKEN_CONTENT,regex:/^([^\[\r\n]+|\[)/},{type:TOKEN_NEWLINE,regex:/^(\r\n|\r|\n)/},{type:TOKEN_OPEN,regex:/^\[[^\[\]]+\]/},{type:TOKEN_CLOSE,regex:/^\[\/[^\[\]]+\]/}];strloop:while(str.length){i=tokenTypes.length;while(i--){type=tokenTypes[i].type;if(!(matches=str.match(tokenTypes[i].regex))||!matches[0]){continue}tokens.push(tokenizeTag(type,matches[0]));str=str.substr(matches[0].length);continue strloop}if(str.length){tokens.push(tokenizeTag(TOKEN_CONTENT,str))}str=""}return tokens};function tokenizeTag(type,val){var matches,attrs,name,openRegex=/\[([^\]\s=]+)(?:([^\]]+))?\]/,closeRegex=/\[\/([^\[\]]+)\]/;if(type===TOKEN_OPEN&&(matches=val.match(openRegex))){name=lower(matches[1]);if(matches[2]&&(matches[2]=matches[2].trim())){attrs=tokenizeAttrs(matches[2])}}if(type===TOKEN_CLOSE&&(matches=val.match(closeRegex))){name=lower(matches[1])}if(type===TOKEN_NEWLINE){name="#newline"}if(!name||(type===TOKEN_OPEN||type===TOKEN_CLOSE)&&!bbcodeHandlers[name]){type=TOKEN_CONTENT;name="#"}return new TokenizeToken(type,name,val,attrs)}function tokenizeAttrs(attrs){var matches,attrRegex=/([^\s=]+)=(?:(?:(["'])((?:\\\2|[^\2])*?)\2)|((?:.(?!\s\S+=))*.))/g,ret={};if(attrs.charAt(0)==="="&&attrs.indexOf("=",1)<0){ret.defaultattr=_stripQuotes(attrs.substr(1))}else{if(attrs.charAt(0)==="="){attrs="defaultattr"+attrs}while(matches=attrRegex.exec(attrs)){ret[lower(matches[1])]=_stripQuotes(matches[3])||matches[4]}}return ret}base.parse=function(str,preserveNewLines){var ret=parseTokens(base.tokenize(str));var opts=base.opts;if(opts.fixInvalidNesting){fixNesting(ret)}normaliseNewLines(ret,null,preserveNewLines);if(opts.removeEmptyTags){removeEmpty(ret)}return ret};function hasTag(name,type,arr){var i=arr.length;while(i--){if(arr[i].type===type&&arr[i].name===name){return true}}return false}function isChildAllowed(parent,child){var parentBBCode=parent?bbcodeHandlers[parent.name]:{},allowedChildren=parentBBCode.allowedChildren;if(base.opts.fixInvalidChildren&&allowedChildren){return allowedChildren.indexOf(child.name||"#")>-1}return true}function parseTokens(toks){var token,bbcode,curTok,clone,i,next,cloned=[],output=[],openTags=[],currentTag=function(){return last(openTags)},addTag=function(token){if(currentTag()){currentTag().children.push(token)}else{output.push(token)}},closesCurrentTag=function(name){return currentTag()&&(bbcode=bbcodeHandlers[currentTag().name])&&bbcode.closedBy&&bbcode.closedBy.indexOf(name)>-1};while(token=toks.shift()){next=toks[0];if(!isChildAllowed(currentTag(),token)){if(token.type!==TOKEN_CLOSE||!currentTag()||token.name!==currentTag().name){token.name="#";token.type=TOKEN_CONTENT}}switch(token.type){case TOKEN_OPEN:if(closesCurrentTag(token.name)){openTags.pop()}addTag(token);bbcode=bbcodeHandlers[token.name];if(bbcode&&!bbcode.isSelfClosing&&(bbcode.closedBy||hasTag(token.name,TOKEN_CLOSE,toks))){openTags.push(token)}else if(!bbcode||!bbcode.isSelfClosing){token.type=TOKEN_CONTENT}break;case TOKEN_CLOSE:if(currentTag()&&token.name!==currentTag().name&&closesCurrentTag("/"+token.name)){openTags.pop()}if(currentTag()&&token.name===currentTag().name){currentTag().closing=token;openTags.pop()}else if(hasTag(token.name,TOKEN_OPEN,openTags)){while(curTok=openTags.pop()){if(curTok.name===token.name){curTok.closing=token;break}clone=curTok.clone();if(cloned.length){clone.children.push(last(cloned))}cloned.push(clone)}if(next&&next.type===TOKEN_NEWLINE){bbcode=bbcodeHandlers[token.name];if(bbcode&&bbcode.isInline===false){addTag(next);toks.shift()}}addTag(last(cloned));i=cloned.length;while(i--){openTags.push(cloned[i])}cloned.length=0}else{token.type=TOKEN_CONTENT;addTag(token)}break;case TOKEN_NEWLINE:if(currentTag()&&next&&closesCurrentTag((next.type===TOKEN_CLOSE?"/":"")+next.name)){if(!(next.type===TOKEN_CLOSE&&next.name===currentTag().name)){bbcode=bbcodeHandlers[currentTag().name];if(bbcode&&bbcode.breakAfter){openTags.pop()}else if(bbcode&&bbcode.isInline===false&&base.opts.breakAfterBlock&&bbcode.breakAfter!==false){openTags.pop()}}}addTag(token);break;default:addTag(token);break}}return output}function normaliseNewLines(children,parent,onlyRemoveBreakAfter){var token,left,right,parentBBCode,bbcode,removedBreakEnd,removedBreakBefore,remove;var childrenLength=children.length;if(parent){parentBBCode=bbcodeHandlers[parent.name]}var i=childrenLength;while(i--){if(!(token=children[i])){continue}if(token.type===TOKEN_NEWLINE){left=i>0?children[i-1]:null;right=i<childrenLength-1?children[i+1]:null;remove=false;if(!onlyRemoveBreakAfter&&parentBBCode&&parentBBCode.isSelfClosing!==true){if(!left){if(parentBBCode.isInline===false&&base.opts.breakStartBlock&&parentBBCode.breakStart!==false){remove=true}if(parentBBCode.breakStart){remove=true}}else if(!removedBreakEnd&&!right){if(parentBBCode.isInline===false&&base.opts.breakEndBlock&&parentBBCode.breakEnd!==false){remove=true}if(parentBBCode.breakEnd){remove=true}removedBreakEnd=remove}}if(left&&left.type===TOKEN_OPEN){if(bbcode=bbcodeHandlers[left.name]){if(!onlyRemoveBreakAfter){if(bbcode.isInline===false&&base.opts.breakAfterBlock&&bbcode.breakAfter!==false){remove=true}if(bbcode.breakAfter){remove=true}}else if(bbcode.isInline===false){remove=true}}}if(!onlyRemoveBreakAfter&&!removedBreakBefore&&right&&right.type===TOKEN_OPEN){if(bbcode=bbcodeHandlers[right.name]){if(bbcode.isInline===false&&base.opts.breakBeforeBlock&&bbcode.breakBefore!==false){remove=true}if(bbcode.breakBefore){remove=true}removedBreakBefore=remove;if(remove){children.splice(i,1);continue}}}if(remove){children.splice(i,1)}removedBreakBefore=false}else if(token.type===TOKEN_OPEN){normaliseNewLines(token.children,token,onlyRemoveBreakAfter)}}}function fixNesting(children,parents,insideInline,rootArr){var token,i,parent,parentIndex,parentParentChildren,right;var isInline=function(token){var bbcode=bbcodeHandlers[token.name];return!bbcode||bbcode.isInline!==false};parents=parents||[];rootArr=rootArr||children;for(i=0;i<children.length;i++){if(!(token=children[i])||token.type!==TOKEN_OPEN){continue}if(insideInline&&!isInline(token)){parent=last(parents);right=parent.splitAt(token);parentParentChildren=parents.length>1?parents[parents.length-2].children:rootArr;if(isChildAllowed(token,parent)){var clone=parent.clone();clone.children=token.children;token.children=[clone]}parentIndex=parentParentChildren.indexOf(parent);if(parentIndex>-1){right.children.splice(0,1);parentParentChildren.splice(parentIndex+1,0,token,right);var next=right.children[0];if(next&&next.type===TOKEN_NEWLINE){if(!isInline(token)){right.children.splice(0,1);parentParentChildren.splice(parentIndex+2,0,next)}}return}}parents.push(token);fixNesting(token.children,parents,insideInline||isInline(token),rootArr);parents.pop()}}function removeEmpty(tokens){var token,bbcode;var isTokenWhiteSpace=function(children){var j=children.length;while(j--){var type=children[j].type;if(type===TOKEN_OPEN||type===TOKEN_CLOSE){return false}if(type===TOKEN_CONTENT&&/\S|\u00A0/.test(children[j].val)){return false}}return true};var i=tokens.length;while(i--){if(!(token=tokens[i])||token.type!==TOKEN_OPEN){continue}bbcode=bbcodeHandlers[token.name];removeEmpty(token.children);if(isTokenWhiteSpace(token.children)&&bbcode&&!bbcode.isSelfClosing&&!bbcode.allowsEmpty){tokens.splice.apply(tokens,[i,1].concat(token.children))}}}base.toHTML=function(str,preserveNewLines){return convertToHTML(base.parse(str,preserveNewLines),true)};function convertToHTML(tokens,isRoot){var undef,token,bbcode,content,html,needsBlockWrap,blockWrapOpen,isInline,lastChild,ret=[];isInline=function(bbcode){return(!bbcode||(bbcode.isHtmlInline!==undef?bbcode.isHtmlInline:bbcode.isInline))!==false};while(tokens.length>0){if(!(token=tokens.shift())){continue}if(token.type===TOKEN_OPEN){lastChild=token.children[token.children.length-1]||{};bbcode=bbcodeHandlers[token.name];needsBlockWrap=isRoot&&isInline(bbcode);content=convertToHTML(token.children,false);if(bbcode&&bbcode.html){if(!isInline(bbcode)&&isInline(bbcodeHandlers[lastChild.name])&&!bbcode.isPreFormatted&&!bbcode.skipLastLineBreak){if(!IE_BR_FIX){content+="<br />"}}if(!isFunction(bbcode.html)){token.attrs["0"]=content;html=formatBBCodeString(bbcode.html,token.attrs)}else{html=bbcode.html.call(base,token,token.attrs,content)}}else{html=token.val+content+(token.closing?token.closing.val:"")}}else if(token.type===TOKEN_NEWLINE){if(!isRoot){ret.push("<br />");continue}if(!blockWrapOpen){ret.push("<div>")}if(!IE_BR_FIX){ret.push("<br />")}if(!tokens.length){ret.push("<br />")}ret.push("</div>\n");blockWrapOpen=false;continue}else{needsBlockWrap=isRoot;html=escapeEntities(token.val,true)}if(needsBlockWrap&&!blockWrapOpen){ret.push("<div>");blockWrapOpen=true}else if(!needsBlockWrap&&blockWrapOpen){ret.push("</div>\n");blockWrapOpen=false}ret.push(html)}if(blockWrapOpen){ret.push("</div>\n")}return ret.join("")}base.toBBCode=function(str,preserveNewLines){return convertToBBCode(base.parse(str,preserveNewLines))};function convertToBBCode(toks){var token,attr,bbcode,isBlock,isSelfClosing,quoteType,breakBefore,breakStart,breakEnd,breakAfter,ret=[];while(toks.length>0){if(!(token=toks.shift())){continue}bbcode=bbcodeHandlers[token.name];isBlock=!(!bbcode||bbcode.isInline!==false);isSelfClosing=bbcode&&bbcode.isSelfClosing;breakBefore=isBlock&&base.opts.breakBeforeBlock&&bbcode.breakBefore!==false||bbcode&&bbcode.breakBefore;breakStart=isBlock&&!isSelfClosing&&base.opts.breakStartBlock&&bbcode.breakStart!==false||bbcode&&bbcode.breakStart;breakEnd=isBlock&&base.opts.breakEndBlock&&bbcode.breakEnd!==false||bbcode&&bbcode.breakEnd;breakAfter=isBlock&&base.opts.breakAfterBlock&&bbcode.breakAfter!==false||bbcode&&bbcode.breakAfter;quoteType=(bbcode?bbcode.quoteType:null)||base.opts.quoteType||QuoteType.auto;if(!bbcode&&token.type===TOKEN_OPEN){ret.push(token.val);if(token.children){ret.push(convertToBBCode(token.children))}if(token.closing){ret.push(token.closing.val)}}else if(token.type===TOKEN_OPEN){if(breakBefore){ret.push("\n")}ret.push("["+token.name);if(token.attrs){if(token.attrs.defaultattr){ret.push("=",quote(token.attrs.defaultattr,quoteType,"defaultattr"));delete token.attrs.defaultattr}for(attr in token.attrs){if(token.attrs.hasOwnProperty(attr)){ret.push(" ",attr,"=",quote(token.attrs[attr],quoteType,attr))}}}ret.push("]");if(breakStart){ret.push("\n")}if(token.children){ret.push(convertToBBCode(token.children))}if(!isSelfClosing&&!bbcode.excludeClosing){if(breakEnd){ret.push("\n")}ret.push("[/"+token.name+"]")}if(breakAfter){ret.push("\n")}if(token.closing&&isSelfClosing){ret.push(token.closing.val)}}else{ret.push(token.val)}}return ret.join("")}function quote(str,quoteType,name){var needsQuotes=/\s|=/.test(str);if(isFunction(quoteType)){return quoteType(str,name)}if(quoteType===QuoteType.never||quoteType===QuoteType.auto&&!needsQuotes){return str}return'"'+str.replace("\\","\\\\").replace('"','\\"')+'"'}function last(arr){if(arr.length){return arr[arr.length-1]}return null}function lower(str){return str.toLowerCase()}}BBCodeParser.QuoteType=QuoteType;BBCodeParser.defaults={breakBeforeBlock:false,breakStartBlock:false,breakEndBlock:false,breakAfterBlock:true,removeEmptyTags:true,fixInvalidNesting:true,fixInvalidChildren:true,quoteType:QuoteType.auto};function toHex(number){number=parseInt(number,10);if(isNaN(number)){return"00"}number=Math.max(0,Math.min(number,255)).toString(16);return number.length<2?"0"+number:number}function _normaliseColour(colorStr){var match;colorStr=colorStr||"#000";if(match=colorStr.match(/rgb\((\d{1,3}),\s*?(\d{1,3}),\s*?(\d{1,3})\)/i)){return"#"+toHex(match[1])+toHex(match[2])+toHex(match[3])}if(match=colorStr.match(/#([0-f])([0-f])([0-f])\s*?$/i)){return"#"+match[1]+match[1]+match[2]+match[2]+match[3]+match[3]}return colorStr}function bbcodeFormat(){var base=this;base.stripQuotes=_stripQuotes;var tagsToBBCodes={};var stylesToBBCodes={};var validChildren={ul:["li","ol","ul"],ol:["li","ol","ul"],table:["tr"],tr:["td","th"],code:["br","p","div"]};function buildBbcodeCache(){each(bbcodeHandlers,function(bbcode){var isBlock,tags=bbcodeHandlers[bbcode].tags,styles=bbcodeHandlers[bbcode].styles;if(tags){each(tags,function(tag,values){isBlock=bbcodeHandlers[bbcode].isInline===false;tagsToBBCodes[tag]=tagsToBBCodes[tag]||{};tagsToBBCodes[tag][isBlock]=tagsToBBCodes[tag][isBlock]||{};tagsToBBCodes[tag][isBlock][bbcode]=values})}if(styles){each(styles,function(style,values){isBlock=bbcodeHandlers[bbcode].isInline===false;stylesToBBCodes[isBlock]=stylesToBBCodes[isBlock]||{};stylesToBBCodes[isBlock][style]=stylesToBBCodes[isBlock][style]||{};stylesToBBCodes[isBlock][style][bbcode]=values})}})}function handleStyles(element,content,blockLevel){var styleValue,format,getStyle=dom.getStyle;blockLevel=!!blockLevel;if(!stylesToBBCodes[blockLevel]){return content}each(stylesToBBCodes[blockLevel],function(property,bbcodes){styleValue=getStyle(element,property);if(!styleValue||getStyle(element.parentNode,property)===styleValue){return}each(bbcodes,function(bbcode,values){if(!values||values.indexOf(styleValue.toString())>-1){format=bbcodeHandlers[bbcode].format;if(isFunction(format)){content=format.call(base,element,content)}else{content=_formatString(format,content)}}})});return content}function handleBlockNewlines(element,content){var tag=element.nodeName.toLowerCase();var isInline=dom.isInline;if(!isInline(element,true)||tag==="br"){var isLastBlockChild,parent,parentLastChild,previousSibling=element.previousSibling;while(previousSibling&&previousSibling.nodeType===1&&!is(previousSibling,"br")&&isInline(previousSibling,true)&&!previousSibling.firstChild){previousSibling=previousSibling.previousSibling}do{parent=element.parentNode;parentLastChild=parent&&parent.lastChild;isLastBlockChild=parentLastChild===element;element=parent}while(parent&&isLastBlockChild&&isInline(parent,true));if(!isLastBlockChild||tag==="li"||tag==="br"&&IE_BR_FIX){content+="\n"}if(tag!=="br"&&previousSibling&&!is(previousSibling,"br")&&isInline(previousSibling,true)){content="\n"+content}}return content}function handleTags(element,content,blockLevel){var convertBBCode,format,tag=element.nodeName.toLowerCase();blockLevel=!!blockLevel;if(tagsToBBCodes[tag]&&tagsToBBCodes[tag][blockLevel]){each(tagsToBBCodes[tag][blockLevel],function(bbcode,bbcodeAttribs){if(bbcodeAttribs){convertBBCode=false;each(bbcodeAttribs,function(attrib,values){if(!attr(element,attrib)||values&&values.indexOf(attr(element,attrib))<0){return}convertBBCode=true;return false});if(!convertBBCode){return}}format=bbcodeHandlers[bbcode].format;if(isFunction(format)){content=format.call(base,element,content)}else{content=_formatString(format,content)}})}return content}function elementToBbcode(element){var toBBCode=function(node,vChildren){var ret="";dom.traverse(node,function(node){var curTag="",nodeType=node.nodeType,tag=node.nodeName.toLowerCase(),vChild=validChildren[tag],firstChild=node.firstChild,isValidChild=true;if(typeof vChildren==="object"){isValidChild=vChildren.indexOf(tag)>-1;if(is(node,"img")&&attr(node,EMOTICON_DATA_ATTR)){isValidChild=true}if(!isValidChild){vChild=vChildren}}if(nodeType!==3&&nodeType!==1){return}if(nodeType===1){if(is(node,".sceditor-nlf")){if(!firstChild||!IE_BR_FIX&&node.childNodes.length===1&&/br/i.test(firstChild.nodeName)){return}}if(tag!=="iframe"){curTag=toBBCode(node,vChild)}if(isValidChild){if(tag!=="code"){curTag=handleStyles(node,curTag);curTag=handleTags(node,curTag);curTag=handleStyles(node,curTag,true)}curTag=handleTags(node,curTag,true);ret+=handleBlockNewlines(node,curTag)}else{ret+=curTag}}else{ret+=node.nodeValue}},false,true);return ret};return toBBCode(element)}base.init=function(){base.opts=this.opts;base.elementToBbcode=elementToBbcode;buildBbcodeCache();this.commands=extend(true,{},defaultCommandsOverrides,this.commands);this.toBBCode=base.toSource;this.fromBBCode=base.toHtml};function toHtml(asFragment,source,legacyAsFragment){var parser=new BBCodeParser(base.opts.parserOptions);var html=parser.toHTML(base.opts.bbcodeTrim?source.trim():source);return asFragment||legacyAsFragment?removeFirstLastDiv(html):html}function toSource(asFragment,html,context,parent){context=context||document;var bbcode,elements;var containerParent=context.createElement("div");var container=context.createElement("div");var parser=new BBCodeParser(base.opts.parserOptions);container.innerHTML=html;css(containerParent,"visibility","hidden");containerParent.appendChild(container);context.body.appendChild(containerParent);if(asFragment){containerParent.insertBefore(context.createTextNode("#"),containerParent.firstChild);containerParent.appendChild(context.createTextNode("#"))}if(parent){css(container,"whiteSpace",css(parent,"whiteSpace"))}elements=container.getElementsByClassName("sceditor-ignore");while(elements.length){elements[0].parentNode.removeChild(elements[0])}dom.removeWhiteSpace(containerParent);bbcode=elementToBbcode(container);context.body.removeChild(containerParent);bbcode=parser.toBBCode(bbcode,true);if(base.opts.bbcodeTrim){bbcode=bbcode.trim()}return bbcode}base.toHtml=toHtml.bind(null,false);base.fragmentToHtml=toHtml.bind(null,true);base.toSource=toSource.bind(null,false);base.fragmentToSource=toSource.bind(null,true)}bbcodeFormat.get=function(name){return bbcodeHandlers[name]||null};bbcodeFormat.set=function(name,bbcode){if(name&&bbcode){bbcode=extend(bbcodeHandlers[name]||{},bbcode);bbcode.remove=function(){delete bbcodeHandlers[name]};bbcodeHandlers[name]=bbcode}return this};bbcodeFormat.rename=function(name,newName){if(name in bbcodeHandlers){bbcodeHandlers[newName]=bbcodeHandlers[name];delete bbcodeHandlers[name]}return this};bbcodeFormat.remove=function(name){if(name in bbcodeHandlers){delete bbcodeHandlers[name]}return this};bbcodeFormat.formatBBCodeString=formatBBCodeString;sceditor.formats.bbcode=bbcodeFormat;sceditor.BBCodeParser=BBCodeParser})(sceditor);