<?php
/**
 * @author Daniel Dimitrov - compojoom.com
 * @date: 11.04.13
 *
 * @copyright  Copyright (C) 2008 - 2013 compojoom.com . All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE
 */

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.modellegacy');


class ccommentModelCaptcha extends JModelLegacy
{

	public function createImage()
	{
		$input = JFactory::getApplication()->input;
		$referenceid = $input->getCmd('refid', md5(time() * rand()));

		$font = JPATH_COMPONENT . "/assets/captcha/century.ttf";
		$background = JPATH_COMPONENT . "/assets/captcha/bg" . rand(1, 3) . '.png';

		$im = ImageCreateFromPNG($background);
		$chars = array("a", "A", "b", "B", "c", "C", "d", "D", "e", "E", "f", "F", "g",
			"G", "h", "H", "i", "I", "j", "J", "k",
			"K", "L", "m", "M", "n", "N", "o", "p", "P", "q", "Q",
			"r", "R", "s", "S", "t", "T", "u", "U", "v",
			"V", "w", "W", "x", "X", "y", "Y", "z", "Z", "2", "3", "4",
			"5", "6", "7", "8", "9");

		$length = 5;
		$textstr = "";

		for ($i = 0; $i < $length; $i++)
		{
			$textstr .= $chars[rand(0, count($chars) - 1)];
		}

		$size = rand(12, 14);
		$angle = rand(-4, 4);

		$color = ImageColorAllocate($im, rand(0, 64), rand(0, 64), rand(0, 64));
		$rk_color = ImageColorAllocate($im, 128, 128, 128);

		$textsize = imagettfbbox($size, $angle, $font, $textstr);
		$twidth = abs($textsize[2] - $textsize[0]);
		$theight = abs($textsize[5] - $textsize[3]);

		$x = (imagesx($im) / 2) - ($twidth / 2) + (rand(-25, 25));
		$y = (imagesy($im)) - ($theight / 2) + 3;

		ImageTTFText($im, $size, $angle, $x + 2, $y + 2, $rk_color, $font, $textstr);
		ImageTTFText($im, $size, $angle, $x, $y, $color, $font, $textstr);

		header("Content-Type: image/png");
		ImagePNG($im);
		imagedestroy($im);

		$this->updateDatabase($referenceid, $textstr);
	}

	private function updateDatabase($referenceid, $textstr)
	{
		$db = JFactory::getDBO();
		$insert = 'INSERT INTO ' . $db->qn('#__comment_captcha') . '(insertdate, referenceid, hiddentext)'
			. ' VALUES (now(),' . $db->q($referenceid) . ',' . $db->q($textstr) . ')';
		$db->setQuery($insert);
		$db->execute();

		$delete = 'DELETE FROM ' . $db->qn('#__comment_captcha') . ' WHERE '
			. ' insertdate < date_sub(now(),interval 1 day)';


		$db->setQuery($delete);
		$db->execute();
	}
}
